function build_model(data::DataBPP)

   T = items(data) 
   K = data.num_bin_types
   maxQ = maximum(data.bin_capacity)

   # Formulation
   bpp = VrpModel()
   @variable(bpp.formulation, x[t in T] >= 0, Int)
   @variable(bpp.formulation, y[k in 1:K] >= 0, Int)
   @constraint(bpp.formulation, cov[t in T], x[t] >= 1.0)
   @constraint(bpp.formulation, avail[k in 1:K], y[k] <= data.bin_availability[k])

   # Objective function
   @objective(bpp.formulation, Min, sum(data.bin_cost[k] * y[k] for k in 1:K))

   #println(bpp.formulation)

   # Build the model directed graph G=(V,A)
   function buildgraph()
      #change the following two lines
      V = vcat([0], T) 
      v_source, v_sink = 0, length(T)

      L, U = 0, length(T) # multiplicity
      G = VrpGraph(bpp, V, v_source, v_sink, (L, U))
      cap_res_id = add_resource!(G, main = true)
      
      # Build set of arcs
      for i in 1:length(T)
         arc_id = add_arc!(G, i-1, i)
         #here you need to set var mapping, arc consumption and arc resource bounds. Examples:
         #add_arc_var_mapping!(G, arc_id, variable)
         #set_arc_consumption!(G, arc_id, resource_id, value)
         #set_arc_resource_bounds!(G, arc_id, resource_id, lb, ub) -> bound is applied after arc consumption
 
         #there is also some code to include after the following line!
         arc_id = add_arc!(G, i-1, i)
      end

      #create multiple arcs going to the sink node
      for k in 1:K
      end
      
      return G
   end

   G = buildgraph()
   add_graph!(bpp, G)
   # println(G)

   A = get_arc_set(G)
   set_arc_packing_sets!(bpp, [[(G,id) for (i,j,id) in A if (j==t && get_arc_consumption(G, id, 1) != 0)] for t in T])

   enable_resource_consumption_branching!(bpp, 2)
   enable_packset_ryanfoster_branching!(bpp, 1)

   return (bpp, x, y)
end
