function build_model(data::DataBPP)

   T = items(data) 
   K = data.num_bin_types
   maxQ = maximum(data.bin_capacity)

   # Formulation
   bpp = VrpModel()
   @variable(bpp.formulation, x[t in T] >= 0, Int)
   @variable(bpp.formulation, y[k in 1:K] >= 0, Int)
   @constraint(bpp.formulation, cov[t in T], x[t] >= 1.0)
   @constraint(bpp.formulation, avail[k in 1:K], y[k] <= data.bin_availability[k])

   # Objective function
   @objective(bpp.formulation, Min, sum(data.bin_cost[k] * y[k] for k in 1:K))

   #println(bpp.formulation)

   # Build the model directed graph G=(V,A)
   function buildgraph()

      V = vcat([0], T, [length(T)+1]) 
      v_source, v_sink = 0, length(T)+1

      L, U = 0, length(T) # multiplicity
      G = VrpGraph(bpp, V, v_source, v_sink, (L, U))
      cap_res_id = add_resource!(G, main = true)

      # Build set of arcs
      for i in 1:length(T)
         arc_id = add_arc!(G, i-1, i)
         add_arc_var_mapping!(G, arc_id, x[i])
         set_arc_consumption!(G, arc_id, cap_res_id, data.weights[i])
         set_arc_resource_bounds!(G, arc_id, cap_res_id, 0.0, maxQ) 

         arc_id = add_arc!(G, i-1, i)
         set_arc_consumption!(G, arc_id, cap_res_id, 0.0)
         set_arc_resource_bounds!(G, arc_id, cap_res_id, 0.0, maxQ) 
      end

      for k in 1:K
         arc_id = add_arc!(G, length(T), length(T)+1)    
         add_arc_var_mapping!(G, arc_id, y[k])
         set_arc_consumption!(G, arc_id, cap_res_id, 0.0)
         set_arc_resource_bounds!(G, arc_id, cap_res_id, 0.0, data.bin_capacity[k]) 
      end

      return G
   end

   G = buildgraph()
   add_graph!(bpp, G)
   #println(G)

   A = get_arc_set(G)
   set_arc_packing_sets!(bpp, [[(G,id) for (i,j,id) in A if (j==t && get_arc_consumption(G, id, 1) != 0)] for t in T])

   enable_resource_consumption_branching!(bpp, 2)
   enable_packset_ryanfoster_branching!(bpp, 1)

   return (bpp, x, y)
end
