import Base.show, Base.print

mutable struct DataBPP
   num_items::Int
   num_bin_types::Int
   weights::Array{Int}
   bin_capacity::Array{Int}
   bin_cost::Array{Int}
   bin_availability::Array{Int}
end

function readBPPData(path_file::String)
  # STEP 1 : pushing data in a vector.
   data = Array{Int,1}()
   open(path_file) do file
      for line in eachline(file)
         for peaceofdata in split(line)
            push!(data, parse(Int, peaceofdata))
         end
      end
   end

   num_items = data[1]
   num_bin_types = data[2]
   bin_capacity = Array{Int,1}()
   bin_cost = Array{Int,1}()
   bin_availability = Array{Int,1}()
   j = 3
   for k in 1:num_bin_types
      push!(bin_capacity, data[j])
      push!(bin_cost, data[j+1])
      push!(bin_availability, data[j+2])
      j += 3
   end
   weights = data[j:end]
   DataBPP(num_items, num_bin_types, weights, bin_capacity, bin_cost, bin_availability)
end

function show(io::IO, d::DataBPP)
   println(io, "Bin Packing dataset.")
   println(io, "number of items = $(d.num_items)")
   println(io, "number of bin types = $(d.num_bin_types)")
   for k in 1:d.num_bin_types
      println(io, "\t bin $k, capacity = $(d.bin_capacity[k])")
   end
   for k in 1:d.num_bin_types
      println(io, "\t bin $k, cost = $(d.bin_cost[k])")
   end
   for k in 1:d.num_bin_types
      println(io, "\t bin $k, availability = $(d.bin_availability[k])")
   end
   println(io, "Weights : ")
   for t in 1:d.num_items
      println(io, "\t item $t, weight= $(d.weights[t])")
   end
end

items(d::DataBPP) = [i for i in 1:d.num_items]
