
function build_model(data::DataBPP)

   T = items(data) 

   # Formulation
   bpp = VrpModel()
   @variable(bpp.formulation, x[t in vcat([0], T)] >= 0, Int)
   @constraint(bpp.formulation, cov[t in T], x[t] == 1.0)

   # Objective function
   @objective(bpp.formulation, Min, x[0])

   #println(bpp.formulation)

   # Build the model directed graph G=(V,A)
   function buildgraph()

      V = vcat([0], T) 
      v_source, v_sink = 0, length(T)

      L, U = 0, length(T) # multiplicity
      G = VrpGraph(bpp, V, v_source, v_sink, (L, U))
      cap_res_id = add_resource!(G, main = true)
      for i in V
         l_i, u_i = 0.0, Float64(data.capacity) # accumulated resource consumption interval [l_i, u_i] for the vertex i
         set_resource_bounds!(G, i, cap_res_id, l_i, u_i)
      end
      
      # Build set of arcs
      for i in 1:length(T)
         arc_id = add_arc!(G, i-1, i)
         if i == 1
            add_arc_var_mapping!(G, arc_id, x[0])
         end
         set_arc_consumption!(G, arc_id, cap_res_id, 0.0)

         arc_id = add_arc!(G, i-1, i)
         add_arc_var_mapping!(G, arc_id, x[i])
         if i == 1
            add_arc_var_mapping!(G, arc_id, x[0])
         end
         set_arc_consumption!(G, arc_id, cap_res_id, data.weights[i])
      end

      return G
   end

   G = buildgraph()
   add_graph!(bpp, G)
   #println(G)

   A = get_arc_set(G)
   set_arc_packing_sets!(bpp, [[(G,id) for (i,j,id) in A if (j==t && get_arc_consumption(G, id, 1) != 0)] for t in T])

   enable_resource_consumption_branching!(bpp, 2)
   enable_packset_ryanfoster_branching!(bpp, 1)

   return (bpp, x)
end
