import Base.show, Base.print

mutable struct DataBPP
   num_items::Int
   weights::Array{Int}
   capacity::Int
end

function readBPPData(path_file::String)
  # STEP 1 : pushing data in a vector.
   data = Array{Int,1}()
   open(path_file) do file
      for line in eachline(file)
         for peaceofdata in split(line)
            push!(data, parse(Int, peaceofdata))
         end
      end
   end

   num_items = data[1]
   capacity = data[2]
   weights = data[3:end]
   DataBPP(num_items, weights, capacity)
end

function show(io::IO, d::DataBPP)
   println(io, "Bin Packing dataset.")
   println(io, "number of items = $(d.num_items)")
   println(io, "capacity = $(d.capacity)")
   println(io, "Weights : ")
   for t in 1:d.num_items
      println(io, "\t item $t, weight= $(d.weights[t])")
   end
end

items(d::DataBPP) = [i for i in 1:d.num_items]